package topdown.operator;

import topdown.data_structures.*;
import topdown.concrete_operator.*;

public interface Operator {

    /*returns iterator of the output relation with respect
    to the well-founded model*/
    public ConcreteOperator instance();

    /*returns iterator of the output relation with respect
    to the interpretation determined by U and L*/
    default public ConcreteOperator instance(int U, int L) {
        return instance();
    }
    
    /*returns true if L isn't sufficient for any
     relevant operator - that is L != L(U)*/
    default public boolean changes(int U, int L) {
        return false;
    }

    /*returns true if U isn't sufficient for any
     relevant operator - that is U != Ufin */
    default public boolean changes(int U) {
        return false;
    }
}
